{              Program:        Space.pas                               }
{              Creation Date:  03-Apr-81                               }
{              Author:         Pieter W. G. Bots                       }
{                              Dickinson College                       }
{                              Carlisle, PA                            }
{                                                                      }
{              Modification History:                                   }
{                                                                      }
{              Ver/Edit        Date            Reason                  }
{              V1.0-01         03-Apr-81       Original release        }
{              V1.0-02         05-Apr-81       Ship-saving features    }
{              V1.0-03         17-Apr-81       Planet appears          }
{              V1.0-04         23-Apr-81       Inventory of fleet      }
{              V1.0-05         06-May-81       Top-Ten feature         }
{                                                                      }
{              V2.0-01         10-May-81       All fleets centralized  }
{              V2.0-02         11-May-81       VT100 features          }
{              V2.0-03         01-Jun-81       Last revision           }
{              V2.0-04         15-Dec-81       Convert data file       }
{                                                                      }
{              V3.0-01         27-Jun-83       Debug, add SPECIAL      }
{              V3.0-02         01-Jul-83       Insert Screener         }
{              V3.0-03         05-Jul-83       Complete and Finish     }
{                                                                      }
{              V4.0-01         07-Jul-83       Modify Procedure Battle }
{              V4.0-02         09-Jul-83       Complete Modifications  }
{              V4.0-03         11-Jul-83       Check out and Install   }
{              V4.0-04         07-Aug-83       Installed               }


Program Space( Input , Output );


{** Global Constants **}

Const   ShipMax   =   15;

type DataArray = Array [0..170] of real;
const Ramps: DataArray =
(        0.0,      1000.0,      2000.0,      3500.0,      5000.0,      7000.0,      9000.0,
     12000.0,     15000.0,     20000.0,     27000.0,     36000.0,     47000.0,     60000.0,
     75000.0,    100000.0,    130000.0,    170000.0,    230000.0,    330000.0,    460000.0,
    620000.0,    750000.0,    900000.0,   1050000.0,   1200000.0,   1400000.0,   1600000.0,
   1800000.0,   2000000.0,   2250000.0,   2500000.0,   2750000.0,   3000000.0,   3250000.0,
   3500000.0,   3800000.0,   4100000.0,   4400000.0,   4700000.0,   5000000.0,   5300000.0,
   5600000.0,   5900000.0,   6200000.0,   6500000.0,   6800000.0,   7100000.0,   7400000.0,
   7700000.0,   8000000.0,   8300000.0,   8600000.0,   8900000.0,   9200000.0,   9500000.0,
   9800000.0,  10000000.0,  10300000.0,  10600000.0,  10900000.0,  11200000.0,  11500000.0,
  11800000.0,  12100000.0,  12400000.0,  12700000.0,  13000000.0,  13300000.0,  13600000.0,
  14000000.0,  14400000.0,  14800000.0,  15200000.0,  15700000.0,  16200000.0,  16700000.0,
  17200000.0,  17700000.0,  18200000.0,  18800000.0,  19400000.0,  20000000.0,  20700000.0,
  21400000.0,  22200000.0,  23000000.0,  23900000.0,  25000000.0,  26200000.0,  27400000.0,
  28600000.0,  29800000.0,  31000000.0,  32400000.0,  33900000.0,  35400000.0,  36900000.0,
  37400000.0,  45000000.0,  56000000.0,  67000000.0,  78000000.0,  89000000.0, 100000000.0,
 110000000.0, 125000000.0, 140000000.0, 160000000.0, 180000000.0, 200000000.0, 220000000.0,
 245000000.0, 270000000.0, 300000000.0, 330000000.0, 360000000.0, 390000000.0, 420000000.0,
 450000000.0, 470000000.0, 490000000.0, 510000000.0, 530000000.0, 550000000.0, 570000000.0,
 590000000.0, 610000000.0, 630000000.0, 650000000.0, 670000000.0, 690000000.0, 705000000.0,
 720000000.0, 735000000.0, 750000000.0, 765000000.0, 780000000.0, 795000000.0, 810000000.0,
 825000000.0, 840000000.0, 855000000.0, 870000000.0, 885000000.0, 900000000.0, 915000000.0,
 930000000.0, 945000000.0, 960000000.0, 980000000.0,1000000000.0,1030000000.0,1080000000.0,
1150000000.0,1240000000.0,1360000000.0,1510000000.0,1660000000.0,1810000000.0,1990000000.0,
2170000000.0,2300000000.0,2600000000.0,2860000000.0,3120000000.0,3380000000.0,3740000000.0,
4110000000.0,4480000000.0,5000000000.0);

{** Global Types **}

Type    Int2    = Array[1..2] of Integer;
        Int3    = Array[1..3] of Integer;
        Int5    = Array[1..5] of Integer;

        Light   = Array[1..20] of Int3;
        Heavy   = Array[1..35] of Int5;

        Char2   = Array[1..2] of Char;
        Char3   = Array[1..3] of Char;

        String1   = string [1];
        String30  = string [30];

        Fleet   = Record
                     Count      : Integer;
                     Name       : Array[1..ShipMax] of String30;
                     Sta,
                     Quests     : Array[1..ShipMax] of Integer;
                     Level,
                     Waste      : Array[1..ShipMax] of Real
                  End;

{** Global Variables **}

Var     BShield,
        Cnt,
        Doppel,
        Enemies,
        FSauc,
        GalCnt,
        Holder,
        Max,
        MCnt,
        PCnt,
        Pstat,
        Rate, Hurt,
        ScreenX, ScreenY,
        SShields, SSize, SX, SY,
        StarCnt,
        Vital,
        IDNum,
        DelTime,
        BeepTime,
        BeepFreq,
        XPl, YPl                        : Integer;

        Energy, Score, Shields,
        Merit,
        Start,
        MaxEnergy, MaxShields           : Real;

        Ship                            : Char;

        AlarmBell,
        Alien,
        APlanet,
        AScreener,
        AutoFire,
        Burnt,
        Buzz,
        Crisped,
        Docked,
        Explo,
        HisFire,
        HitBase,
        Invisible,
        Over,
        PKiller,
        Used                            : Boolean;

        Ships                           : Heavy;
        Stars                           : Light;

        Spot                            : Int2;

        Base                            : Int3;

        Inv                             : Array[1..9] of Integer;

        Dir                             : Array[1..9] of Int2;

        BShip,
        Cruiser,
        DStar,
        GiantS,
        Horror,
        PlasmS,
        Saucer,
        SBase                           : Char3;

        Header                          : Array[1..5] of Char;

        Planet                          : Record
                                             OutSide : Array[1..30] of Int5;
                                             InSide  : Array[1..11] of Int5
                                          End;

        VersionNum                      : Array[1..10] of Char;


{** File declarations **}

ShipFil : File of Fleet;


{** Pascal Functions **}

Function DrawNumber(N: integer): integer;
begin
   if N > 0 then
      DrawNumber := Random(N)
   else
      DrawNumber := 0
end;


Function Value( T : Char2 ) : Integer;

Var     Sum     : Integer;

Begin
   Sum := 0;
   If  ( Ord( T[ 1 ] ) > 47 )
   and ( Ord( T[ 1 ] ) < 58 ) then
      Sum := Ord( T[ 1 ] ) - 48;
   If  ( Ord( T[ 2 ] ) > 47 )
   and ( Ord( T[ 2 ] ) < 58 ) then
      Sum := 10 * Sum + Ord( T[ 2 ] ) - 48;
   Value := Sum
End;


Function ShotCount : Integer;

Var     Count: Integer;
        Total: Real;
Begin
   Count := 0;
   if Score < 5.0E+9 then
   begin
      while Score >= Ramps[Count] do Count := Count + 1
   end
   else
   begin
      Total := Score;
      Repeat
         Count := Count + 1;
         Total := Total / 1.2;
      Until Total <= 1000;
      Count := Count * 2 - 1;
      If Total > 500 then
         Count := Count + 1
   end;
   ShotCount := Count
End;


Function WhereToShoot( X, Y : Integer ) : Integer;

Var     Dir,
        Mis     : Integer;

Begin
   Dir := 0;
   If Alien
   or APlanet
   or AScreener
   or ( FSauc > 0 )
   or ( AutoFire and HisFire ) then
      Mis := 0
   else
      Mis := DrawNumber( 2 ) - 1;
   If X = Spot[ 1 ] - Mis then
      Begin
         If Y < Spot[ 2 ] then
            Dir := 6
         else
            Dir := 4;
      End
   else
   if Y = Spot[ 2 ] - Mis then
      Begin
         If X > Spot[ 1 ] then
            Dir := 8
         else
            Dir := 2;
      End
   else
   if ( X - Spot[ 1 ] ) =
      ( Y - Spot[ 2 ] ) - Mis then
      Begin
         If Spot[ 1 ] > X then
            Dir := 3
         else
            Dir := 7;
      End
   else
   if ( X - Spot[ 1 ] ) =
     -( Y - Spot[ 2 ] ) - Mis then
      Begin
         If Spot[ 1 ] >  X then
            Dir := 1
         else
            Dir := 9;
      End;
   WhereToShoot := Dir
End;


Function Bell: String1;

Begin
   If Buzz then
   begin
      Sound(BeepFreq);
      Delay(BeepTime);
      NoSound
   end;
   Bell := ''
End;


Function Upper( A : Char ) : Char;

Begin
   If  ( Ord( A ) > 96 )
   and ( Ord( A ) < 123 ) then
      Upper := Chr( Ord( A ) - 32 )
   else
      Upper := A;
End;



Function EmptySpot( X, Y : Integer ) : Boolean;

Var     J       : Integer;

Begin
   EmptySpot := True;
   For J := 1 to StarCnt do
      If  ( X = Stars[ J, 1 ] )
      and ( Y >= Stars[ J, 2 ] - 1 )
      and ( Y <= Stars[ J, 2 ] + 1 ) then
         EmptySpot := False;
   For J := 1 to Enemies do
      If  ( X = Ships[ J, 1 ] )
      and ( Y >= Ships[ J, 2 ] - 3 )
      and ( Y <= Ships[ J, 2 ] + 3 ) then
         EmptySpot := False;
   If  ( Base[ 1 ] = X )
   and ( Base[ 2 ] > Y - 4 )
   and ( Base[ 2 ] < Y + 4 ) then
      EmptySpot := False;
   If ( X <  2 )
   or ( X > 22 )
   or ( Y <  3 )
   or ( Y > 77 ) then
      EmptySpot := False;
   If APlanet and ( ( Abs( X - XPl ) < 5) or ( Abs( Y - YPl ) < 3 ) ) then
      EmptySpot := False;
End;


Procedure Sleep( SectoSlp : integer );

Begin
   Delay( SectoSlp * 1000)
End;


{** Pascal Procedures **}

Procedure WriteTime( T: Real );

Var     Hrs,
        Mins    : Integer;

Begin
   Mins := Round( T * 60 );
   Hrs := Mins div 60;
   Mins := Mins mod 60;
   Write( Hrs:4, ':' );
   If Mins < 10 then
      Write( '0' );
   Write( Mins:1 )
End;


Procedure Cursor( R, C : Integer );

Begin
   If  ( R >  0  )
   and ( R <= 24 )
   and ( C >  0  )
   and ( C <= 80 ) then
      GotoXY(C,R)
End;


Procedure Home;

Begin
   GotoXY(1,1)
End;


Procedure ClearEOS;
var X,Y: integer;
Begin
   ClrEol;
   X := WhereX;
   Y := WhereY;
   While WhereY < 25 do
   begin
      writeln;
      ClrEol
   end;
   GotoXY(X,Y)
End;


Procedure Clear;

Begin
   ClrScr
End;


Procedure Video( N : Integer );

Begin
   Case N of
   0: begin
         TextColor(LightGray);
         TextBackground(Black)
      end;
   1: begin
         TextColor(White);
         TextBackground(Black)
      end;
   4: begin
         TextColor(Blink+LightGray);
         TextBackground(Black)
      end;
   5: begin
         TextColor(Blink+White);
         TextBackground(Black)
      end;
   2: begin
         TextColor(Blue);
         TextBackground(Black)
      end;
   3: begin
         TextColor(LightBlue);
         TextBackground(Black)
      end;
   6: begin
         TextColor(Blue+Blink);
         TextBackground(Black)
      end;
   7: begin
         TextColor(LightBlue+Blink);
         TextBackground(Black)
      end;
   8: begin
         TextColor(Black);
         TextBackground(White)
      end;
  9,10,11:
      begin
         TextColor(Black);
         TextBackground(White)
      end;
12,13,14,15:
      begin
         TextColor(Black + Blink);
         TextBackground(White)
      end;
   End
End;


Procedure Status( Option : Integer );

Var     E,
        I, J,
        R       : Integer;

Begin
   E := Enemies;
   If Alien then
      Begin
         E := E - 10;
         For I := Vital - 5 to Vital + 5 do
            If ( I <= 0 ) then
               E := E + 1
            else
            if ( Ships[ I, 3 ] < 10 )
            or ( Ships[ I, 3 ] = 46 )
            or (( Ships[ I, 3 ] = 91 ) and ( Ships[ I, 5 ] <> 15000 ))
            or (( Ships[ I, 3 ] = 60 ) and ( Ships[ I, 5 ] <> 15000 )) then
               E := E + 1;
      End;
   If APlanet or AScreener then
      E := 1;
   R := 5 + 5 * Rate * Hurt;
   If Option = 1 then
      Begin
         Cursor( 23, 3 );
         Write( 'Energy : ' );
         If Energy < 300 + R then
            Video( 5 );
         Write( Energy:7:0 );
         Video( 0 );
         Write( '  Shield strength : ' );
         If Shields < R then
            Video( 5 );
         Write( Shields:5:0 );
         Video( 0 );
         Write( '  Score : ', Score:16:0 );
         ClrEOL;
         Cursor( 24, 3 );
         Write( 'Fire rate : ', Rate:4, '  Laser strength : ', Hurt:6,
                '  Enemies : ', E:14 );
         ClrEOL
      End
   else
   if Option = 0 then
      Begin
         Cursor( 23, 12 );
         If Energy < 300 + R then
            Video(5 );
         Write( Energy:7:0 );
         Video( 0 );
         Cursor( 23, 39 );
         If Shields < R then
            Video( 5 );
         Write( Shields:5:0 );
         Video( 0 );
         Cursor( 23, 54 );
         Write( Score:16:0 );
         Cursor( 24, 15 );
         Write( Rate:4 );
         Cursor( 24, 38 );
         Write( Hurt:6 );
         Cursor( 24, 56 );
         Write( E:14 )
      End;
   If Not( AlarmBell )
   and (( Energy < 300 + R ) or ( Shields < R )) then
      For I := 1 to 3 do
         Begin
            Cursor( 2, 79 );
            Video( 1 );
            Write( #4#7 );
            Video( 0 );
            Delay(200);
            Write( #8' ' );
            Delay(200);
            AlarmBell := True
         End
End;


Procedure HisShip;

Begin
   Cursor ( Spot[ 1 ] , Spot[ 2 ] );
   Video( 1 );
   write(#4);
   Video( 0 )
End;


Procedure WriteShip( S : Int5 );

Begin
   If S[ 3 ] = -1 then
      Write( Ship )
   else
   if S[ 3 ] = 1 then
      Write( Chr( 8 ), DStar )
   else
   if S[ 3 ] = 2 then
      Write( Chr( 8 ), BShip )
   else
   if S[ 3 ] = 3 then
      Write( Chr( 8 ), Cruiser )
   else
   if S[ 3 ] = 4 then
      Write( Chr( 8 ), Horror )
   else
   if S[ 3 ] = 5 then
      Write( Chr( 8 ), GiantS )
   else
   if S[ 3 ] = 6 then
      Write( Chr( 8 ), PlasmS )
   else
   if S[ 3 ] = 7 then
      Write( Chr( 8 ), Saucer )
   else
      Write( Chr( S[ 3 ] ));
End;



Procedure PrintScreener;

Var     I, J,
        X, Y    : Integer;

Begin
   X := SX - SSize - 1;
   Y := SY - SSize div 2 - 1;
{*********************************************************************}
{
        Area of the screener defined as the center
}
{*********************************************************************}
   ScreenX := X + ( SSIZE div 2 );
   ScreenY := Y + ( SSIZE div 2 ) + 1;
   Cursor( Y, X );
   Write( '' );
   For I := 2 to 2 * SSize do
      Write( '' );
   Write( 'Ŀ' );
   For I := 1 to SSize do
      Begin
         Cursor( Y + I, X );
         Write( ' ' );
         For J := 2 to 2 * SSize do
            Write( ' ' );
         Write( ' ' )
      End;
   Cursor( Y + SSize + 1, X );
   Write( '' );
   For I := 2 to 2 * SSize do
      Write( '' );
   Write( '' )
End;


Procedure Implode;

Var     I       : Integer;

Begin
   Video( 5 );
   While SSize > 0 do
      Begin
         PrintScreener;
         SSize := SSize - 2;
         Sleep(1)
      End;
   Video( 0 );
   Cursor(SY, SX);
   If Shields <= 0 then
      Begin
         Write( #4#8 );
         Sleep(1)
      End;
   Write( #250#7 );
   Cursor( 1, 1 );
   Sleep(3)
End;


Procedure ScreenSetup;

Var     I       : Integer;

Begin
   Clear;
   For I := 1 to Enemies do
      Begin
         Cursor( Ships[ I, 1 ], Ships[ I, 2 ] );
         WriteShip( Ships[ I ] );
      End;
   Video( 1 );
   For I := 1 to StarCnt do
      Begin
         Cursor( Stars[ I, 1 ], Stars[ I, 2 ] );
         Write( #249 );
      End;
   Video( 0 );
   If  ( Base[ 1 ] > 1 )
   and ( Base[ 2 ] > 1 ) then
      Begin
         If Docked then
            Video( 1 );
         If Base[ 3 ] > 0 then
            Video( 5 );
         Cursor( Base[ 1 ], Base[ 2 ] - 1 );
         Write( SBase );
         Video( 0 );
      End;
   If APlanet then
      With Planet do
         Begin
            Video( 5 );
            For I := 1 to 11 do
               If Inside[ I, 4 ] > 0 then
                  Begin
                     Cursor( Inside[ I, 1 ], Inside[ I, 2 ] );
                     Write( Chr( Inside[ I, 3 ] ))
                  End;
            Video( 0 );
            For I := 1 to 30 do
               If OutSide[ I, 4 ] > 0 then
                  Begin
                     Cursor( Outside[ I, 1 ], Outside[ I, 2 ] );
                     Write( Chr( Outside[ I, 3 ] ))
                  End
         End
   else
   If AScreener then
      PrintScreener;
   HisShip;
   Status( 1 );
   If AutoFire then
      Begin
         Cursor( 1, 1 );
         Video( 5 );
         Write( ' ' );
         Video( 0 )
      End
End;


Procedure PlaceStars( Var S : Light );

Var     I       : Integer;

Begin
   StarCnt := DrawNumber( 10 ) + 10;
   Video( 1 );
   For I := 1 to StarCnt do
      Begin
         S[ I, 1 ] := DrawNumber( 17 ) + 3;
         S[ I, 2 ] := DrawNumber( 73 ) + 3;
         S[ I, 3 ] := 75;
         Cursor( S[ I, 1 ], S[ I, 2 ] );
         Write( #249 )
      End;
   Video( 0 )
End;


Procedure Explosion( R, C, O : Integer );

Var     I, J    : Integer;

Begin
   If O = 0 then
      Video( 5 );
   Cursor( R, C - 2 );
   If O = 0 then
      Write( '<[*]>', Bell )
   else
   if O = 1 then
      Write( '     ' )
   else
      Write( '~~~~~' );
   Delay(10*O);
   Cursor( R - 1, C - 1 );
   If O = 0 then
      Write( #39'^`', Bell )
   else
   if O = 1 then
      Write( '   ' )
   else
      Write( '~~~' );
   Delay(10*O);
   Cursor( R + 1, C - 1 );
   If O = 0 then
      Write( #39, 'v`', Bell )
   else
   if O = 1 then
      Write( '   ' )
   else
      Write( '~~~' );
   Delay(10*O);
   Cursor( R, C - 5 );
   If O = 0 then
      Write( '-<', Bell )
   else
   if O = 1 then
      Write( '  ' )
   else
      Write( '~ ' );
   Delay(10*O);
   Cursor( R, C + 4 );
   If O = 0 then
      Write( '>-', Bell )
   else
   if O = 1 then
      Write( '  ' )
   else
      Write( ' ~' );
   Video( 0 );
   Delay(10*O);
   Cursor( R - 2, C - 2 );
   If O = 0 then
      Write( '\   /', Bell )
   else
   if O = 1 then
      Write( '     ' )
   else
      Write( '~ ~ ~' );
   Delay(10*O);
   Cursor( R + 2, C - 2 );
   If O = 0 then
      Write( '/   \', Bell )
   else
   if O = 1 then
      Write( '     ' )
   else
      Write( '~ ~ ~' );
   Delay(10*O);
   Cursor( R, C - 6 );
   If O = 0 then
      Write( '<', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Delay(10*O);
   Cursor( R, C + 6 );
   If O = 0 then
      Write( '>', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Delay(10*O);
   Cursor( R - 3, C );
   If O = 0 then
      Write( '|', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Delay(10*O);
   Cursor( R + 3, C );
   If O = 0 then
      Write( '|', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Cursor( R - 1, C - 4 );
   Delay(10*O);
   If O = 0 then
      Write( '//', Bell )
   else
   if O = 1 then
      Write( '  ' )
   else
      Write( '~~' );
   Delay(10*O);
   Cursor( R + 1, C + 3 );
   If O = 0 then
      Write( '//', Bell )
   else
   if O = 1 then
      Write( '  ' )
   else
      Write( '~~' );
   Delay(10*O);
   Cursor( R - 1, C + 3 );
   If O = 0 then
      Write( '\\', Bell )
   else
   if O = 1 then
      Write( '  ' )
   else
      Write( '~~' );
   Delay(10*O);
   Cursor( R + 1, C - 4 );
   If O = 0 then
      Write( '\\', Bell )
   else
   if O = 1 then
      Write( '  ' )
   else
      Write( '~~' );
   Delay(10*O);
   Cursor( R, C - 8 );
   If O = 0 then
      Write( '--', Bell )
   else
   if O = 1 then
      Write( '  ' )
   else
      Write( '~ ' );
   Delay(10*O);
   Cursor( R, C + 7 );
   If O = 0 then
      Write( '--', Bell )
   else
   if O = 1 then
      Write( '  ' )
   else
      Write( ' ~' );
   Delay(10*O);
   Cursor( R + 3, C - 1 );
   If O = 0 then
      Write( '<|>', Bell )
   else
   if O = 1 then
      Write( '   ' )
   else
      Write( #8'  ~  ' );
   Cursor( R - 3, C - 1 );
   Delay(10*O);
   If O = 0 then
      Write( '<|>', Bell )
   else
   if O = 1 then
      Write( '   ' )
   else
      Write( #8'  ~  ' );
   Cursor( R - 1, C - 5 );
   Delay(10*O);
   If O = 0 then
      Write( '/', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Cursor( R - 1, C + 5 );
   Delay(10*O);
   If O = 0 then
      Write( '\', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Delay(10*O);
   Cursor( R + 1, C - 5 );
   If O = 0 then
      Write( '\', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Delay(10*O);
   Cursor( R + 1, C + 5 );
   If O = 0 then
      Write( '/', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Delay(10*O);
   Cursor( R - 2, C - 3 );
   If O = 0 then
      Write( '\', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Delay(10*O);
   Cursor( R - 2, C + 3 );
   If O = 0 then
      Write( '/', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Cursor( R + 2, C - 3 );
   Delay(10*O);
   If O = 0 then
      Write( '/', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Delay(10*O);
   Cursor( R + 2, C + 3 );
   If O = 0 then
      Write( '\', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Delay(10*O);
   Cursor( R - 4, C );
   If O = 0 then
      Write( '|', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   Delay(10*O);
   Cursor( R + 4, C );
   If O = 0 then
      Write( '|', Bell )
   else
   if O = 1 then
      Write( ' ' )
   else
      Write( '~' );
   If O = 0 then
      For I := 1 to 10 do
         Write( Bell );
   If  ( Abs( R - Spot[ 1 ] ) < 6 )
   and ( Abs( C - Spot[ 2 ] ) < 10 ) then
      Shields := ( Shields - 100 ) - 100 * DrawNumber( 30 );
   Explo := True
End;


{      /[=]\      }
{     //   \\     }
{    // (+) \\    }
{   (( <>*<> ))   }
{    \\ (+) //    }
{     \\   //     }
{      \[=]/      }

Procedure AlienPlanet( R, C : Integer );

Var     I       : Integer;

Begin
   With Planet do
      Begin
         For I := 1 to 2 do
            Begin
               OutSide[ I, 3 ] := 61;
               Outside[ I, 4 ] := 500;
               Outside[ I, 5 ] := 25000;        { The '=' }
               Outside[ I + 2, 3 ] := 91;
               Outside[ I + 2, 4 ] := 300;
               Outside[ I + 2, 5 ] := 15000;    { The '[' }
               Outside[ I + 4, 3 ] := 93;
               Outside[ I + 4, 4 ] := 300;
               Outside[ I + 4, 5 ] := 15000;    { The ']' }
               Outside[ I + 6, 3 ] := 40;
               Outside[ I + 6, 4 ] := 250;
               Outside[ I + 6, 5 ] := 12500;    { The '(' }
               Outside[ I + 8, 3 ] := 41;
               Outside[ I + 8, 4 ] := 250;
               Outside[ I + 8, 5 ] := 12500;    { The ')' }

               Inside[ I + 1, 3 ] := 60;
               Inside[ I + 1, 4 ] := 400;
               Inside[ I + 1, 5 ] := 15000;     { The '<' }
               Inside[ I + 3, 3 ] := 62;
               Inside[ I + 3, 4 ] := 400;
               Inside[ I + 3, 5 ] := 15000;     { The '>' }
               Inside[ I + 5, 3 ] := 40;
               Inside[ I + 5, 4 ] := 500;
               Inside[ I + 5, 5 ] := 27500;     { The '(' }
               Inside[ I + 7, 3 ] := 41;
               Inside[ I + 7, 4 ] := 500;
               Inside[ I + 7, 5 ] := 27500;     { The ')' }
               Inside[ I + 9, 3 ] := 43;
               Inside[ I + 9, 4 ] := 350;
               Inside[ I + 9, 5 ] := 20000      { The '+' }
            End;
         For I := 1 to 10 do
            Begin
               Outside[ I + 10, 3 ] := 92;
               Outside[ I + 10, 4 ] := 350;
               Outside[ I + 10, 5 ] := 15000;   { The '\' }
               Outside[ I + 20, 3 ] := 47;
               Outside[ I + 20, 4 ] := 350;
               Outside[ I + 20, 5 ] := 15000    { The '/' }
            End;
         Inside[ 1, 1 ] := R;
         Inside[ 1, 2 ] := C;
         Inside[ 1, 3 ] := 42;
         Inside[ 1, 4 ] := 1200;
         Inside[ 1, 5 ] := 30000;               { The Real Thing }

         Inside[ 2, 1 ] := R;
         Inside[ 2, 2 ] := C - 2;
         Inside[ 3, 1 ] := R;
         Inside[ 3, 2 ] := C + 1;
         Inside[ 4, 1 ] := R;
         Inside[ 4, 2 ] := C - 1;
         Inside[ 5, 1 ] := R;
         Inside[ 5, 2 ] := C + 2;
         Inside[ 6, 1 ] := R - 1;
         Inside[ 6, 2 ] := C - 1;
         Inside[ 7, 1 ] := R + 1;
         Inside[ 7, 2 ] := C - 1;
         Inside[ 8, 1 ] := R - 1;
         Inside[ 8, 2 ] := C + 1;
         Inside[ 9, 1 ] := R + 1;
         Inside[ 9, 2 ] := C + 1;
         Inside[ 10, 1 ] := R - 1;
         Inside[ 10, 2 ] := C;
         Inside[ 11, 1 ] := R + 1;
         Inside[ 11, 2 ] := C;

         Outside[ 1, 1 ] := R + 3;
         Outside[ 1, 2 ] := C;
         Outside[ 2, 1 ] := R - 3;
         Outside[ 2, 2 ] := C;
         Outside[ 3, 1 ] := R + 3;
         Outside[ 3, 2 ] := C - 1;
         Outside[ 4, 1 ] := R - 3;
         Outside[ 4, 2 ] := C - 1;
         Outside[ 5, 1 ] := R + 3;
         Outside[ 5, 2 ] := C + 1;
         Outside[ 6, 1 ] := R - 3;
         Outside[ 6, 2 ] := C + 1;
         Outside[ 7, 1 ] := R;
         Outside[ 7, 2 ] := C - 5;
         Outside[ 8, 1 ] := R;
         Outside[ 8, 2 ] := C - 4;
         Outside[ 9, 1 ] := R;
         Outside[ 9, 2 ] := C + 4;
         Outside[ 10, 1 ] := R;
         Outside[ 10, 2 ] := C + 5;
         Outside[ 11, 1 ] := R - 3;
         Outside[ 11, 2 ] := C + 2;
         Outside[ 12, 1 ] := R - 2;
         Outside[ 12, 2 ] := C + 2;
         Outside[ 13, 1 ] := R - 2;
         Outside[ 13, 2 ] := C + 3;
         Outside[ 14, 1 ] := R - 1;
         Outside[ 14, 2 ] := C + 3;
         Outside[ 15, 1 ] := R - 1;
         Outside[ 15, 2 ] := C + 4;
         Outside[ 16, 1 ] := R + 1;
         Outside[ 16, 2 ] := C - 4;
         Outside[ 17, 1 ] := R + 1;
         Outside[ 17, 2 ] := C - 3;
         Outside[ 18, 1 ] := R + 2;
         Outside[ 18, 2 ] := C - 3;
         Outside[ 19, 1 ] := R + 2;
         Outside[ 19, 2 ] := C - 2;
         Outside[ 20, 1 ] := R + 3;
         Outside[ 20, 2 ] := C - 2;
         Outside[ 21, 1 ] := R - 3;
         Outside[ 21, 2 ] := C - 2;
         Outside[ 22, 1 ] := R - 2;
         Outside[ 22, 2 ] := C - 3;
         Outside[ 23, 1 ] := R - 2;
         Outside[ 23, 2 ] := C - 2;
         Outside[ 24, 1 ] := R - 1;
         Outside[ 24, 2 ] := C - 4;
         Outside[ 25, 1 ] := R - 1;
         Outside[ 25, 2 ] := C - 3;
         Outside[ 26, 1 ] := R + 1;
         Outside[ 26, 2 ] := C + 3;
         Outside[ 27, 1 ] := R + 1;
         Outside[ 27, 2 ] := C + 4;
         Outside[ 28, 1 ] := R + 2;
         Outside[ 28, 2 ] := C + 3;
         Outside[ 29, 1 ] := R + 2;
         Outside[ 29, 2 ] := C + 2;
         Outside[ 30, 1 ] := R + 3;
         Outside[ 30, 2 ] := C + 2;
         Repeat
            Spot[ 1 ] := DrawNumber( 20 ) + 2;
            Spot[ 2 ] := DrawNumber( 75 ) + 2;
         Until ( Abs( Spot[ 1 ] - R ) > 4 )
         and   ( Abs( Spot[ 2 ] - C ) > 6 );
         HisShip;
         Enemies := 0;
         StarCnt := 0;
         ScreenSetup;
         Video( 5 );
         For I := 1 to 11 do
            Begin
               Cursor( Inside[ I, 1 ], Inside[ I, 2 ] );
               Write( Chr( Inside[ I, 3 ] ));
            End;
         Video( 0 );
         For I := 1 to 30 do
            Begin
               Cursor( Outside[ I, 1 ], Outside[ I, 2 ] );
               Write( Chr( Outside[ I, 3 ] ))
            End;
      End;
   APlanet := True
End;



Procedure PlaceAlien;

Var     I,
        Col, Row : Integer;

Begin
   Row := DrawNumber( 10 ) + 6;
   Col := DrawNumber( 30 ) + 25;
   For I := Enemies + 1 to Enemies + 3 do
      Begin
         Ships[ I, 1 ] := Row - 1;
         Ships[ I, 2 ] := Col - Enemies - 2 + I;
         Ships[ I, 4 ] := 100;
         Ships[ I, 5 ] := 22500;
      End;
   For I := Enemies + 4 to Enemies + 8 do
      Begin
         Ships[ I, 1 ] := Row;
         Ships[ I, 2 ] := Col - Enemies - 6 + I;
         Ships[ I, 4 ] := 75;
         Ships[ I, 5 ] := 15000;
         If I = Enemies + 6 then
            Begin
               Vital := I;
               Ships[ I, 4 ] := 250;
               Ships[ I, 5 ] := 30000;
            End;
      End;
   For I := Enemies + 9 to Enemies + 11 do
      Begin
         Ships[ I, 1 ] := Row + 1;
         Ships[ I, 2 ] := Col - Enemies - 10 + I;
         Ships[ I, 4 ] := 100;
         Ships[ I, 5 ] := 22500;
      End;
   Ships[ Enemies + 1, 3 ] := 47;
   Ships[ Enemies + 2, 3 ] := 61;
   Ships[ Enemies + 3, 3 ] := 92;
   Ships[ Enemies + 4, 3 ] := 60;
   Ships[ Enemies + 5, 3 ] := 91;
   Ships[ Enemies + 6, 3 ] := 42;
   Ships[ Enemies + 7, 3 ] := 93;
   Ships[ Enemies + 8, 3 ] := 62;
   Ships[ Enemies + 9, 3 ] := 92;
   Ships[ Enemies + 10, 3 ] := 61;
   Ships[ Enemies + 11, 3 ] := 47;
   For I := Enemies + 1 to Enemies + 11 do
      Begin
         If I = Vital then
            Video( 1 );
         Cursor( Ships[ I, 1 ], Ships[ I, 2 ] );
         Write( Chr( Ships[ I, 3 ] ));
         Video( 0 )
      End;
   Enemies := Enemies + 11;
   Alien := True
End;



Procedure PlaceShips;

Label 1;

Var     I, J,
        R,
        X, Y    : Integer;

Begin
   Merit := 0;
   FSauc := 0;
   Doppel := 0;
   Alien := False;
   For I := 1 to 35 do
      Begin
         Ships[ I, 1 ] := 0;
         Ships[ I, 2 ] := 0;
         Ships[ I, 3 ] := 0;
         Ships[ I, 4 ] := 0;
         Ships[ I, 5 ] := 0
      End;
   For I := 1 to Enemies do
      Begin
         Repeat
            X := DrawNumber( 16 ) + 4;
            Y := DrawNumber( 70 ) + 5
         Until EmptySpot( X, Y );
         Ships[ I, 1 ] := X;
         Ships[ I, 2 ] := Y;
         If Score < 32767 then
            R :=  DrawNumber( 20 ) + Trunc( Score / 1000 )
         else
         if Score < 75000.0 then
            R := DrawNumber( 30 ) + 25
         else
         if Score < 150000.0 then
            R := DrawNumber( 40 ) + 40
         else
         if Score < 1000000.0 then
            R := DrawNumber( 50 ) + 50
         else
            R := DrawNumber( 61 ) + 50;
         If ( R > 109 )
         and ( Merit = 0 )
         and ( Score > 75000000.0 ) then
            Begin
               Ships[ I, 3 ] := -1;
               Ships[ I, 4 ] := ShotCount * ( 35 + ( ShotCount div 30 ));
               Ships[ I, 5 ] := 10000;
               Merit := Ships[ I, 4 ];
               Merit := Merit * 300.0;
               Doppel := I
            End
         else
         if ( R > 106 )
         and ( FSauc = 0 )
         and ( Score > 15000000.0 ) then
            Begin
               Ships[ I, 3 ] := 7;
               Ships[ I, 4 ] := 500;
               Ships[ I, 5 ] := 12000;
               FSauc := I
            End
         else
         if ( R > 103 )
         and ( Score > 5000000.0 ) then
            Begin
               Enemies := I - 1;
               PlaceAlien;
               goto 1
            End
         else
         if R > 97 then
            Begin
               Ships[ I, 3 ] := 46;
               Ships[ I, 4 ] := 500;
               Ships[ I, 5 ] := 30000
            End
         else
         if R > 82 then
            Begin
               Ships[ I, 3 ] := 4;
               Ships[ I, 4 ] := 200;
               Ships[ I, 5 ] := 7500
            End
         else
         if R > 72 then
            Begin
               Ships[ I, 3 ] := 5;
               Ships[ I, 4 ] := 100;
               Ships[ I, 5 ] := 4500
            End
         else
         if R > 55 then
            Begin
               Ships[ I, 3 ] := 6;
               Ships[ I, 4 ] := 75;
               Ships[ I, 5 ] := 3000
            End
         else
         if R > 42 then
            Begin
               Ships[ I, 3 ] := 1;
               Ships[ I, 4 ] := 50;
               Ships[ I, 5 ] := 1500
            End
         else
         if R > 33 then
            Begin
               Ships[ I, 3 ] := 2;
               Ships[ I, 4 ] := 25;
               Ships[ I, 5 ] := 750
            End
         else
         if R > 23 then
            Begin
               Ships[ I, 3 ] := 3;
               Ships[ I, 4 ] := 10;
               Ships[ I, 5 ] := 350
            End
         else
         if R > 18 then
            Begin
               Ships[ I, 3 ] := 37;
               Ships[ I, 4 ] := 5;
               Ships[ I, 5 ] := 100
            End
         else
         if R > 10 then
            Begin
               Ships[ I, 3 ] := 93;
               Ships[ I, 4 ] := 2;
               Ships[ I, 5 ] := 15
            End
         else
            Begin
               Ships[ I, 3 ] := 62;
               Ships[ I, 4 ] := 1;
               Ships[ I, 5 ] := 5
            End;
         Cursor( Ships[ I, 1 ], Ships[ I, 2 ] );
         If ( Score > 3000000.0 )
         and ( DrawNumber( 10 ) > 9 )
         and ( I <> FSauc )
         and ( Ships[ I, 3 ] <> -1 ) then
            Ships[ I, 3 ] := 91
         else
         if ( Score > 3000000.0 )
         and ( DrawNumber( 10 ) > 7 )
         and ( I <> FSauc )
         and ( Ships[ I, 3 ] <> -1 ) then
            Ships[ I, 3 ] := 60;
         WriteShip( Ships[ I ] )
      End;
1: End;



Procedure StarBase;
Var     I, Temp,
        X, Y            : Integer;

Begin
   I := Trunc( Shields / 100 );
   If Aplanet then
     Temp := 100
   Else
     Temp := 0;
   If (((  DrawNumber(I)+Temp) = 0 ) or
        (  Energy  <  1200   )    or
        (  Shields <   900   ))   and
        (  DrawNumber(2) = 1    )    then
      Begin
         BShield := 300 + DrawNumber( 150 );
         Repeat
            X := DrawNumber( 16 ) + 4;
            Y := DrawNumber( 70 ) + 5
         Until EmptySpot( X, Y );
         Base[ 1 ] := X;
         Base[ 2 ] := Y;
         Cursor( Base[ 1 ], Base[ 2 ] - 1 );
         Base[ 3 ] := 0;
         Write( SBase )
      End
   else
      Begin
         Base[ 1 ] := 0;
         Base[ 2 ] := 0;
         Base[ 3 ] := 0
      End
End;



Procedure Dock( Option : Integer );

Var     I               : Integer;
        RealShields     : Real;

Begin
   Spot[ 1 ] := Base[ 1 ];
   Spot[ 2 ] := Base[ 2 ];
   If Base[ 3 ] = 0 then
      Begin
         Energy := 1200 + 100 * ShotCount;
         RealShields := 75 + 50 * ( ShotCount - 1 );
         If RealShields > 32750.0 then
            Shields := 32750
         else
            Shields := Round( RealShields );
         Docked := True;
         MaxEnergy := Energy;
         MaxShields := Shields;
      End
   else
      Begin
         Energy := 0;
         Shields := 1;
         Write( Chr( 7 ));
         Cursor( Base[ 1 ], Base[ 2 ] );
         Video ( 3 );
         Write( '*' );
         Video ( 1 );
         Cursor( Base[ 1 ], Base[ 2 ] - 1 );
         Delay(500);
         Write ('(=)');
         Cursor( Base[ 1 ], Base[ 2 ] );
         Write( #250#8 );
         Delay(200);
         Video ( 0 );
         Write( '~' );
         Write( Chr( 7 ));
         Delay( 500 );
         Write( Chr( 7 ));
         Burnt := True;
      End;
   If  ( Option = 1 )
   and ( Base[ 1 ] > 1 )
   and ( Base[ 2 ] > 1 ) then
      Begin
         Cursor( Base[ 1 ], Base[ 2 ] - 1 );
         Video( 1 );
         If Base[ 3 ] > 0 then
            Video( 4 );
         Write( '(', Ship, ')' );
         Video( 0 );
         Status( 0 )
      End
End;



Procedure PutHimDown;

Begin
   Repeat
      Spot[ 1 ] := DrawNumber( 16 ) + 4;
      Spot[ 2 ] := DrawNumber( 70 ) + 5
   Until EmptySpot( Spot[ 1 ], Spot[ 2 ] )
   and ((Abs(SY - Spot[ 1 ]) * 2 > SSize) and (Abs(SX - Spot[ 2 ]) > SSize)
       or not AScreener);
{*********************************************************************}
{
        Placement of your ship with a screener
}
{*********************************************************************}
   If AScreener and ((Spot[ 1 ] < ScreenX+5) and (Spot [ 1 ] > ScreenX-5))
   and ((Spot [ 2 ] < ScreenY + 9 ) and ( Spot [ 2 ] > ScreenY - 9 )) then
      Begin
        If ( ScreenX + 3 < 10 ) and ( ScreenY + 3 < 32 ) then
          Begin
            Spot[ 1 ] := Spot [ 1 ] + 6 ;
            If Spot [ 1 ] > 19 then Spot [ 1 ] := 18;
            Spot[ 2 ] := Spot [ 2 ] + 8 ;
            If Spot [ 2 ] > 74 then Spot [ 2 ] := 73;
          End;
        If ( ScreenX + 3 >= 10 ) and ( ScreenY + 3 >= 32 ) then
          Begin
            Spot[ 1 ] := Spot [ 1 ] - 6 ;
            If Spot [ 1 ] < 3 then Spot [ 1 ] := 3;
            Spot[ 2 ] := Spot [ 2 ] + 8 ;
            If Spot [ 2 ] < 3 then Spot [ 2 ] := 3;
          End;
      End;
   HisShip;
   Status( 1 )
End;


Procedure Screener;

Var I,
    X, Y        : Integer;

Begin
   AScreener := True;
   SSize := DrawNumber( 2 ) * 2 + 1;
   SX := DrawNumber( 60 ) + 10;
   SY := DrawNumber( 14 ) + 5;
   SShields := 1500 + 1000 * SSize;
   StarBase;
   Repeat
      Spot[ 1 ] := DrawNumber( 16 ) + 4;
      Spot[ 2 ] := DrawNumber( 70 ) + 5
   Until EmptySpot( Spot[ 1 ], Spot[ 2 ] )
   and (Abs(SY - Spot[ 1 ]) * 2 > SSize + 2)
   and (Abs(SX - Spot[ 2 ]) > SSize + 2);
   ScreenSetup
End;


Procedure Fire( R, C, D, P, T : Integer );

Label 1,2;

Var     I, J, K, L: Integer;

        Torp            : Char;

        Blank,
        HitStar,
        Zapped          : Boolean;

        Move            : Array[1..2] of Integer;

Begin
   Case D of    1       : Begin
                             Move[ 1 ] := -1;
                             Move[ 2 ] := 1;
                             Torp := '/'
                          End;
                2       : Begin
                             Move[ 1 ] := 0;
                             Move[ 2 ] := 1;
                             Torp := ''
                          End;
                3       : Begin
                             Move[ 1 ] := 1;
                             Move[ 2 ] := 1;
                             Torp := '\'
                          End;
                4       : Begin
                             Move[ 1 ] := -1;
                             Move[ 2 ] := 0;
                             Torp := '-'
                          End;
                6       : Begin
                             Move[ 1 ] := 1;
                             Move[ 2 ] := 0;
                             Torp := '-'
                          End;
                7       : Begin
                             Move[ 1 ] := -1;
                             Move[ 2 ] := -1;
                             Torp := '\'
                          End;
                8       : Begin
                             Move[ 1 ] := 0;
                             Move[ 2 ] := -1;
                             Torp := ''
                          End;
                9       : Begin
                             Move[ 1 ] := 1;
                             Move[ 2 ] := -1;
                             Torp := '/'
                          End;
   End;
   If APlanet and Not( HisFire ) then
      Torp := Chr( 42 );
   Cursor( R, C );
   For I := 1 to P do
      Begin
         Zapped := False;
         HitStar := False;
         Blank := True;
         C := C + Move[ 1 ];
         R := R + Move[ 2 ];
         If ( C > 78 )
         or ( C < 1 )
         or ( R > 22 )
         or ( R < 1 ) then
            Goto 1;
      If Not( Invisible ) then
       Begin
         If APlanet or HisFire then
            Video( 1 );
         if I > 1 then
            Begin
               Cursor( R, C );
               Write( Torp );
               if D in [1,2,3,7,8,9] then
                  delay(DelTime)
               else
                  delay(DelTime div 2)
            End;
         Video( 0 )
       End;
         If APlanet then
            Begin
               For J := 1 to 11 do
                  If  ( R = Planet.Inside[ J, 1 ] )
                  and ( C = Planet.Inside[ J, 2 ] )
                  and ( Planet.Inside[ J, 4 ] > 0 ) then
                     Begin
                        Zapped := True;
                        If HisFire
                        or HitBase then
                           Begin
                              Planet.Inside[ J, 4 ] := Planet.Inside[ J, 4 ]
                                                                        - T;
                              Write( Bell )
                           End;
                        If Planet.Inside[ J, 4 ] <= 0 then
                          Begin
                            If J = 1 then
                              Begin
                                 Score := Score + 100100100.0;
                                 Explosion( XPl, YPl, 0 );
                                 Explosion( XPl, YPl, 2 );
                                 Sleep( 1 );
                                 Explosion( XPl, YPl, 1 );
                                 Over := True;
                                 Explo := False;
                                 APlanet := False
                               End
                           else
                              Begin
                                 Cursor( R, C );
                                 Write( '~' );
                                 Write( Bell );
                                 Score := Score + Planet.Inside[ J, 5 ]
                              End
                          End
                        else
                           Begin
                              Cursor( R, C );
                              Video( 5 );
                              Write( Chr( Planet.Inside[ J, 3 ] ));
                              Video( 0 )
                           End;
                        If HisFire
                        or HitBase then
                           Begin
                              Write( Bell );
                              Goto 1
                           End
                     End;
               For J := 1 to 30 do
                  If  ( R = Planet.Outside[ J, 1 ] )
                  and ( C = Planet.Outside[ J, 2 ] )
                  and ( Planet.Outside[ J, 4 ] > 0 ) then
                     Begin
                        Zapped := True;
                        If HisFire
                        or HitBase then
                           Planet.Outside[ J, 4 ] := Planet.Outside[ J, 4 ]
                                                                        - T;
                        If Planet.Outside[ J, 4 ] <= 0 then
                           Begin
                              Cursor( R, C );
                              Write( '~' );
                              Write( Bell );
                              Score := Score + Planet.Outside[ J, 5 ]
                           End
                        else
                           Begin
                              Cursor( R, C );
                              Write( Chr( Planet.Outside[ J, 3 ] ) )
                           End;
                        If Hisfire
                        or HitBase then
                           Begin
                              Write( Bell );
                              Goto 1
                           End
                     End;
            End
         else
         If AScreener then
            Begin
               If (R >= SY - SSize div 2 - 1)
               and (R <= SY + SSize div 2 + 1)
               and (C >= SX - SSize - 1)
               and (C <= SX + SSize + 1)
               and ( HisFire or HitBase ) then
                  Begin
                     If Not( Invisible ) then
                        PrintScreener;
                     Write( Bell );
                     SShields := SShields - T;
                     If SShields <= 0 then
                        Begin
                           Score := Score + (Sqr( SSize ) div 3 + 1) * 1.5e8;
                           AScreener := False;
                           Implode
                        End;
                     Goto 1
                  End
            End
         else
         For J := 1 to Enemies do
            If  ( R = Ships[ J, 1 ] )
            and ( C = Ships[ J, 2 ] ) then
               Begin
                  If Not( Alien and ( I < 5 ))
                  or HisFire then
                     Begin
                        Ships[ J, 4 ] := Ships[ J, 4 ] - T;
                        Write( Bell );
                        If J = FSauc then
                           Begin
                              Cursor( Ships[ J, 1 ], Ships[ J, 2 ] - 1 );
                              Write( Saucer );
                              Fire( Ships[ J, 1 ], Ships[ J, 2 ], Inv[ D ],
                                    Trunc( T * 1.5 ), 75 )
                           End
                     End;
                  Zapped := True;
                  If Ships[ J, 4 ] <= 0 then
                     Begin
                        If Alien
                        and ( J = Vital ) then
                           Begin
                              Alien := False;
                              MCnt := MCnt + 1;
                              Vital := -1
                           End;
                        If ( J = FSauc )
                        and ( FSauc > 0 ) then
                           Begin
                              Score := Score + 200000.0;
                              FSauc := -1
                           End;
                        Cursor( R, C );
                        If  ( Ships[ J, 3 ] < 10 )
                        and ( Ships[ J, 3 ] > 0  ) then
                           Write( #8' ~ '#8#8 )
                        else
                           Write( '~'#8 );
                        Write( Bell );
                        Score := Score + Ships[ J, 5 ];
                        If Ships[ J, 3 ] = -1 then
                           Begin
                              Score := Score + Merit;
                              Doppel := -1
                           End;
                        If Vital > J then
                           Vital := Vital - 1;
                        If FSauc > J then
                           FSauc := FSauc - 1;
                        If Doppel > J then
                           Doppel := Doppel - 1;
                        For K := J to Enemies - 1 do
                           Ships[ K ] := Ships[ K + 1 ];
                        Enemies := Enemies - 1
                     End
                  else
                     Begin
                        Cursor( R, C );
                        If J = Vital then
                           Video( 1 );
                        WriteShip( Ships[ J ] );
                        Video( 0 )
                     End;
                  Goto 1
               End;
         For J := 1 to StarCnt do
            If  ( R = Stars[ J, 1 ] )
            and ( C = Stars[ J, 2 ] ) then
               Begin
                  Cursor( R, C );
                  Video(1);
                  Write( '*' );
                  Video(0);
                  Delay(200);
                  HitStar := True;
                  Stars[ J, 3 ] := Stars[ J, 3 ] - T;
                  If Stars[ J, 3 ] <= 0 then
                     Begin
                        HitStar := False;
                        Stars[ J, 1 ] := 0;
                        Stars[ J, 2 ] := 0;
                        Write( #8' ' );
                        For K := J to StarCnt - 1 do
                           Stars[ K ] := Stars[ K + 1 ];
                        StarCnt := StarCnt - 1
                     End;
                  If HitStar then
                  Begin
                     Cursor( R, C );
                     Video( 1 );
                     Write( #249 );
                     Video( 0 );
                  End;
                  goto 1
               End;
         if  Not( Zapped or Invisible )
         and ( I > 1 )
         and Blank then
            Begin
               Cursor( R, C );
               Write( ' ' )
            End;
         If  ( R = Spot[ 1 ] )
         and ( C = Spot[ 2 ] )
         and Not( Docked ) then
            Begin
               Shields := Shields - T;
               Goto 1
            End;
         If  ( R = Base[ 1 ] )
         and ( I >= 1 ) then
            For J := -1 to 1 do
               If ( C = Base[ 2 ] + J ) then
                  Begin
                     If HisFire then
                        Begin
                           Base[ 3 ] := 1;
                           BShield := BShield - T
                        End
                     else
                        BShield := BShield - ( T div 2 );
                     If Not( HitBase ) then
                        Begin
                           HitBase := True;
                           Fire( Base[ 1 ], Base[ 2 ] + J, Inv[ D ], 80, 2*T )
                        End;
                     If ( Base[ 1 ] > 0 )
                     and ( BShield <= 0 ) then
                        Begin
                           Cursor( Base[ 1 ], Base[ 2 ] + 1 );
                           Write( Chr( 8 ), Chr( 8 ), '~~~' );
                           Score := Score + 50000.0;
                           Docked := False;
                           Base[ 1 ] := 0;
                           Base[ 2 ] := 0;
                           Base[ 3 ] := 0
                        End
                     else
                        if Base[ 1 ] > 0 then
                           Begin
                              Cursor( Base[ 1 ], Base[ 2 ] - 1 );
                              If Base[ 3 ] > 0 then
                                 Video( 5 );
                              Write( SBase );
                              Video( 0 )
                           End;
                     HitBase := False;
                     If Docked then
                        Begin
                           Video( 1 );
                           Write( #8#8, Ship );
                           Video( 0 )
                        End;
                     Goto 1
                  End
      End;
1:    HisShip;
      Status( 0 )
End;


