{$I SPACE1}

function Time: real;

type DOSRecord = record
                    AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags: integer
                 end;

var D: DOSRecord;
    U,M,S,F: integer;

begin
   with D do
   begin
      AX := $2C00;
      MsDos(D);
      U := hi(CX);
      M := lo(CX);
      S := hi(DX);
      F := lo(DX)
   end;
   Time := U + M / 60 + S / 3600
end;

Procedure Service( Var IR : Boolean );

Var     I,
        W,
        FLeft   : Integer;

Begin
   FLeft := ShotCount;
   I := 0;
   Repeat
      I := I + 1;
      HisFire := True;
      W := WhereToShoot( Ships[ I, 1 ], Ships[ I, 2 ] );
      If W > 0 then
         Begin
            If  ( Ships[ I, 4 ] < FLeft )
            and ( Ships[ I, 4 ] > 0 ) then
               Begin
                  FLeft := FLeft - Ships[ I, 4 ];
                  Energy := Energy - Ships[ I, 4 ];
                  Fire( Spot[ 1 ], Spot[ 2 ], Inv[ W ], 80, Ships[ I, 4 ] );
                  I := I - 1
               End
            else
               Begin
                  Energy := Energy - FLeft;
                  Fire( Spot[ 1 ], Spot[ 2 ], Inv[ W ], 80, FLeft );
                  FLeft := 0
               End
         End
   Until ( FLeft <= 0 ) or ( Enemies = 0 ) or ( I >= Enemies );
   If FLeft <= 0 then
      IR := True
   else
      IR := False
End;


Procedure TheirTurn;

Var     I, J,
        Direct,
        Displ,
        Mis,
        Range,
        Rate,
        X, Y    : Integer;

        Creat,
        Shot    : Boolean;

Begin
   HisFire := False;
   Creat := False;
   If FSauc > 0 then
    Begin
      Cursor( Ships[ FSauc, 1 ], Ships[ FSauc, 2 ] - 1 );
      Write( '   ' );
      Repeat
         Repeat
            Displ :=  DrawNumber( 20 ) - 10
         Until Abs( Displ ) > 1;
         X := Spot[ 1 ] + Displ;
         If DrawNumber( 7 ) = 0 then
            X := Spot[ 1 ];
         If DrawNumber( 2 ) = 0 then
            Displ := - Displ;
         Y := Spot[ 2 ] + Displ
      Until EmptySpot( X, Y );
      Ships[ FSauc, 1 ] := X;
      Ships[ FSauc, 2 ] := Y;
      Cursor( Ships[ FSauc, 1 ], Ships[ FSauc, 2 ] - 1 );
      Write( Saucer );
      If WhereToShoot( Ships[ FSauc, 1 ], Ships[ FSauc, 2 ] ) > 0 then
         Fire( Ships[ FSauc, 1 ], Ships[ FSauc, 2 ],
               WhereToShoot( Ships[ FSauc, 1 ], Ships[ FSauc, 2 ] ),
               75, DrawNumber( 50 ) + 100 )
     End;
   If Doppel > 0 then
    Begin
      Cursor( Ships[ Doppel, 1 ], Ships[ Doppel, 2 ] );
      Write( ' ' );
      Repeat
         Repeat
            Displ :=  DrawNumber( 20 ) - 10
         Until Abs( Displ ) > 1;
         X := Spot[ 1 ] + Displ;
         If DrawNumber( 7 ) = 0 then
            X := Spot[ 1 ];
         If DrawNumber( 2 ) = 0 then
            Displ := - Displ;
         Y := Spot[ 2 ] + Displ
      Until EmptySpot( X, Y );
      Ships[ Doppel, 1 ] := X;
      Ships[ Doppel, 2 ] := Y;
      Cursor( Ships[ Doppel, 1 ], Ships[ Doppel, 2 ] );
      Write( Ship );
      Shot := False;
      If WhereToShoot( Ships[ Doppel, 1 ], Ships[ Doppel, 2 ] ) > 0 then
         Fire( Ships[ Doppel, 1 ], Ships[ Doppel, 2 ],
               WhereToShoot( Ships[ Doppel, 1 ], Ships[ Doppel, 2 ] ),
               75, ShotCount )
     End;
   For I := 1 to Enemies do
      Begin
         Direct := 0;
         Rate := 50;
         Case Ships[ I, 3 ] of   1 : Begin
                                        Rate := 10 + DrawNumber( 10 );
                                        Range := 55
                                     End;
                                 0 : Begin
                                        Rate := DrawNumber( ShotCount div 2 ) * 2;
                                        Range := 80
                                     End;
                                 2 : Begin
                                        Rate := 7 + DrawNumber( 7 );
                                        Range := 45
                                     End;
                                 3 : Begin
                                        Rate := 5 + DrawNumber( 6 );
                                        Range := 35
                                     End;
                                 4 : Begin
                                        Rate := 15 + DrawNumber( 15 );
                                        Range := 80
                                     End;
                                91,
                                60,
                                42,
                               126,
                                 5 : Begin
                                        Rate := 20 + DrawNumber( 20 );
                                        Range := 70
                                     End;
                                 6 : Begin
                                        Rate := 30 + DrawNumber( 30 );
                                        Range := 65
                                     End;
                                46 : Begin
                                        Rate := 10 + DrawNumber( 15 );
                                        Range := 75
                                     End;
                                37 : Begin
                                        Rate := 3;
                                        Range := 25
                                     End;
                                62 : Begin
                                        Rate := 1;
                                        Range := 20
                                     End;
                                93 : Begin
                                        Rate := 1;
                                        Range := 22
                                     End;
         End;
         Mis := DrawNumber( 2 );
         If Alien
         or ( FSauc > 0 ) then
            Begin
               Mis := 1;
               Range := 75;
               Rate := 10 + DrawNumber( 30 )
            End;
         If Abs( Spot[ 2 ] - Ships[ I, 2 ] ) <= Range then
            Direct := WhereToShoot( Ships[ I, 1 ], Ships[ I, 2 ] );
         If Alien and Not( Creat ) and ( Enemies < 35 ) then
            Begin
               Enemies := Enemies + 1;
               Creat := True;
               Repeat
                  Repeat
                     Displ :=  DrawNumber( 20 ) - 10
                  Until Displ <> 0;
                  Ships[ Enemies, 1 ] := Spot[ 1 ] + Displ;
                  If DrawNumber( 7 ) = 0 then
                     Ships[ Enemies, 1 ] := Spot[ 1 ];
                  If DrawNumber( 2 ) = 0 then
                     Displ := - Displ;
                  Ships[ Enemies, 2 ] := Spot[ 2 ] + Displ;
                  For J := 1 to Enemies - 1 do
                     If  ( Ships[ Enemies, 1 ] = Ships[ J, 1 ] )
                     and ( Ships[ Enemies, 2 ] = Ships[ J, 2 ] ) then
                        Ships[ Enemies, 1 ] := 0;
                  If  ( Ships[ Enemies, 2 ] >= Base[ 2 ] - 1 )
                  and ( Ships[ Enemies, 2 ] <= Base[ 2 ] + 1 )
                  and ( Ships[ Enemies, 1 ] = Base[ 1 ] ) then
                     Ships[ Enemies, 1 ] := 0
               Until ( Ships[ Enemies, 1 ] > 1 )
               and   ( Ships[ Enemies, 1 ] < 22 )
               and   ( Ships[ Enemies, 2 ] > 1 )
               and   ( Ships[ Enemies, 2 ] < 78 );
               Ships[ Enemies, 3 ] := 46;
               Ships[ Enemies, 4 ] := 200;
               Ships[ Enemies, 5 ] := 15000;
               Cursor( Ships[ Enemies, 1 ], Ships[ Enemies, 2 ] );
               Write( '.' );
            End;
         If Direct > 0 then
            Fire( Ships[ I, 1 ], Ships[ I, 2 ], Direct, Range, Rate )
      End;
   If APlanet then
    Begin
      For I := 1 to 11 do
         If Planet.Inside[ I, 4 ] > 0 then
            Begin
               Direct := WhereToShoot(Planet.Inside[I,1], Planet.Inside[I,2]);
               If Direct > 0 then
                  Fire( Planet.Inside[ I, 1 ], Planet.Inside[ I, 2 ], Direct,
                        65, DrawNumber( 50 ) + 75 );
            End;
      For I := 1 to 30 do
         If Planet.Outside[ I, 4 ] > 0 then
            Begin
               Direct := WhereToShoot(Planet.Outside[I,1],Planet.Outside[I,2]);
               If Direct > 0 then
                  Fire( Planet.Outside[ I, 1 ], Planet.Outside[ I, 2 ], Direct,
                        65, DrawNumber( 50 ) + 75 )
            End
    End
   else
   If AScreener then
      Begin
         Cursor( Spot[1], Spot[2] );
         Write( ' ' );
         For I := 0 to DrawNumber( 2 ) do
          Begin
           X := ( SX - Spot[ 2 ] ) div 2;
           Y := SY - Spot[ 1 ];
           If Abs( X ) > Abs( Y ) then
              Spot[2] := Spot[2] + 2 * (X div abs(X))
           else
              Spot[1] := Spot[1] + Y div Abs(Y)
          End;
         If ( Spot[ 1 ] = Base[ 1 ] )
         and ( Spot[ 2 ] = Base[ 2 ] )
         and ( BShield > 0 ) then
            Dock( 1 )
         else
         If ( Base[ 1 ] <> 0 )
         and ( BShield <> 0 ) then
            Begin
               Cursor( Base[ 1 ], Base[ 2 ] - 1 );
               Write( SBase )
            End;
         If (Abs(SY - Spot[ 1 ]) * 2 <= SSize + 1)
         and (Abs(SX - Spot[ 2 ]) <= SSize + 1) and AScreener then
            Begin
               Shields := 0;
               Implode
            End
         else
            Begin
               HisShip;
               For X := SX - SSize - 1 to SX + SSize + 1 do
                  For Y := SY - SSize div 2 - 1 to SY + SSize div 2 + 1 do
                     Begin
                        Direct := WhereToShoot( Y, X );
                        If Direct > 0 then
                           Begin
                              Fire( Y, X, Direct, 80, DrawNumber(50) + 70 );
                              Shot := True
                           End
                     End;
               If Shot and Not( Invisible ) then
                  PrintScreener
            End
      End
End;



Procedure HyperSpace;

Var     NPlace,
        PCount,
        R       : Integer;

Begin
   AlarmBell := False;
   FSauc := 0;
   Doppel := 0;
   Enemies := 0;
   APlanet := False;
   Docked := False;
   AutoFire := False;
   AScreener := False;
   Base[ 1 ] := 0;
   Base[ 2 ] := 0;
   Base[ 3 ] := 0;
   Clear;
   Energy := Energy - 50 - DrawNumber( 300 );
   If ShotCount >= 152 then
      Begin
         If PKiller and (DrawNumber( 4 ) <= 0) then
            Screener
         else
         if Not( PKiller ) and (DrawNumber( 15 ) <= 0) then
            APlanet := True
      End;
   If Not( PKiller )
   and ( APlanet or ( Not ( AScreener ))
   and ( DrawNumber ( 160 - ShotCount ) <= 0)
   and ( DrawNumber ( 10 ) <= 1 )) then
      Begin
         XPl := 10 + DrawNumber( 4 );
         YPl := 25 + DrawNumber( 30 );
         AlienPlanet( XPl, YPl );
         StarBase;
         Status( 1 )
      End
   else if Not( AScreener ) then
      Begin
         Enemies := DrawNumber( 19 ) + 1;
         PlaceStars( Stars );
         PlaceShips;
         StarBase;
         PutHimDown
      End
End;


Procedure Battle;

Label   1;

Var     Direct,
        I,
        PCount,
        Range,
        Step,
        XMove,YMove     : Integer;

Var     Answer,
        Command,
        Com1, Com2,
        PrevCh          : Char;

        Done,
        InRange,
        Shot            : Boolean;

        OldSpot         : Int2;
        FStep           : Char2;


Begin
   Rate := 1;
   Direct := 8;
   XMove := 0;
   YMove := 0;
   Done := False;
   Invisible := False;
   AutoFire := False;
   Repeat
      If Not( ( InRange ) or ( FSauc > 0 ) or ( Doppel > 0 ))
      or Not( AutoFire )
      or Docked
      or ( Shields < 1500 )
      or ( Energy < 2000 ) then
    Begin
      If Docked
      or ( Shields < 1500 )
      or ( Energy < 2000 ) then
         Begin
            AutoFire := False;
            Cursor( 1, 1 );
            Write( ' ' )
         End;
      Repeat
         PrevCh := Command;
         Read(Kbd, Command );
         Command := Upper( Command )
      Until Command in [#1,'0'..'9',';','A','F','H','I','J','K','L','N','M','O','P','S','Z','W'];
      Hurt := ShotCount div Rate;
      OldSpot[ 1 ] := Spot[ 1 ];
      OldSpot[ 2 ] := Spot[ 2 ];
      Shot := True;
      XMove := 0; YMove := 0;
      Case Command of 'H' : If Spot[ 1 ] > 2 then
                               YMove := -1;
                      'P' : If Spot[ 1 ] < 21 then
                               YMove := 1;
                      'M' : If Spot[ 2 ] < 78 then
                               XMove := 1;
                      'K' : If Spot[ 2 ] > 2 then
                               XMove := -1;
                      'F' : Begin
                               Repeat
                                  Read(kbd, FStep[ 1 ] )
                               Until ( Ord( FStep[ 1 ] ) > 47 )
                               and   ( Ord( FStep[ 1 ] ) < 58 );
                               Read( kbd, FStep[ 2 ] );
                               Rate := Value( FStep );
                               while FStep[2] in ['0'..'9'] do
                                  read(kbd,FStep[2]);
                               If Rate > ShotCount then
                                  Rate := ShotCount;
                               If Rate < 1 then
                                  Rate := 1;
                               Hurt := ShotCount div Rate;
                               Status( 0 );
                               Shot := False
                            End;
                      'L' : Begin
                               If ( Score > 50000000.0 )
                               and Not( AScreener )
                               and Not( APlanet ) then
                               Begin
                                  AutoFire := Not( AutoFire );
{ If on top of enemy no autofire }
                                  For I := 1 to Enemies do
                                     If  ( Spot[ 1 ] = Ships[ I, 1 ] )
                                     and ( Spot[ 2 ] = Ships[ I, 2 ] )
                                        then AutoFire := False
                               End;
                               If AutoFire then
                               Begin
                                  Cursor( 1, 1 );
                                  Video( 5 );
                                  write('');
                                  Video( 0 )
                               End
                               else
                               Begin
                                  Cursor( 1, 1 );
                                  Write( ' ' )
                               End;
                               InRange := True;
                               Shot := False
                            End;
                      'O' : Begin
                               Buzz := Not( Buzz );
                               Shot := False
                            End;
                  'Z',';' : If Not( Docked ) then
                            Begin
                               For I := 1 to Rate do
                               Begin
                                  HisFire := True;
                                  Range := 17 + ShotCount + GalCnt;
                                  Fire(Spot[ 1 ],Spot[ 2 ],Direct,Range,Hurt);
                                  Energy := Energy - Hurt
                               End
                            End;
                      'W' : HyperSpace;
                      'N' : Begin
                               ScreenSetup;
                               Shot := False
                            End;
                      'J' : Begin
                               Repeat
                                  Read( Kbd, FStep[ 1 ] )
                               Until ( Ord( FStep[ 1 ] ) > 47 )
                               and   ( Ord( FStep[ 1 ] ) < 58 );
                               read(Kbd, FStep[2]);
                               Step := Value( FStep );
                               If Step > ShotCount then
                                  Step := ShotCount;
                               read(Kbd,Command);
                               while not(Command in [#72,#75,#77,#80]) do
                               read( kbd, Command );
                               Case Command of
                                'H' : If Spot[ 1 ] > Step + 1 then
                                         YMove := -Step
                                      else
                                         YMove := 2 - Spot[ 1 ];
                                'P' : If Spot[ 1 ] < 21 - Step then
                                         YMove := Step
                                      else
                                         YMove := 21 - Spot[ 1 ];
                                'M' : If Spot[ 2 ] < 77  - Step then
                                         XMove := Step
                                      else
                                         XMove := 77 - Spot[ 2 ];
                                'K' : If Spot[ 2 ] > 2 + Step then
                                         XMove := -Step
                                      else
                                         XMove := 2 - Spot[ 2 ];
                               End
                            End;
                      'S' : Done := True;
                      'I' : Begin
                               Invisible := Not( Invisible );
                               Shot := False
                            End;
                       #1 : Begin
                               Read( kbd, Com1 );
                               Read( kbd, Com2 );
                               If (Com1 = #17) and (Com2 = #24) then
                               Begin
                                  GotoXY(1,1);
                                  write('Score: ');
                                  read(Score);
                                  GotoXY(1,1);
                                  ClrEol;
                                  Dock(0);
                                  Docked := false;
                                  ScreenSetup
                               End;
                               Goto 1;
                            End;
               '1','2','3',
               '4','6',
               '7','8','9': begin
                               Direct := Ord( Command ) - 48;
                               if (FSauc > 0) or (Doppel > 0) then
                                  Shot := false
                            end;
      else
         if Not( AutoFire ) then Shot := False;
      End
      End;
      Spot[ 1 ] := Spot[ 1 ] + YMove;
      Spot[ 2 ] := Spot[ 2 ] + XMove;
      If (Abs(SY - Spot[ 1 ]) * 2 <= SSize )
      and (Abs(SX - Spot[ 2 ]) <= SSize ) and AScreener then
         Begin
            Shields := 0;
            Implode;
            Goto 1
         End;
      Crisped := False;
      For I := 1 to StarCnt do
         If  ( Spot[ 1 ] = Stars[ I, 1 ] )
         and ( Spot[ 2 ] = Stars[ I, 2 ] ) then
            Begin
               Shields := Shields - DrawNumber( 100 ) - 100;
               Cursor( Spot[ 1 ], Spot[ 2 ] );
               Video( 1 );
               Write( '*'#8 );
               Write( Bell,Bell,Bell );
               Video( 0 );
               Status( 0 );
               Crisped := True
            End;
      If  ( Spot[ 1 ] = Base[ 1 ] )
      and ( Spot[ 2 ] = Base[ 2 ] ) then
         Begin
            Cursor( OldSpot[ 1 ], OldSpot[ 2 ] );
            Write( ' ' );
            Dock( 1 )
         End
      else
         Begin
            If Docked then
               Begin
                  Cursor( Base[ 1 ], Base[ 2 ] - 1 );
                  Write( SBase )
               End;
            If Ord( Command ) <> 32 then
             Begin
              Cursor( OldSpot[ 1 ], OldSpot[ 2 ] );
              Write( ' ', Chr( 8 ) );
              For I := 1 to StarCnt do
                If  ( OldSpot[ 1 ] = Stars[ I, 1 ] )
                and ( OldSpot[ 2 ] = Stars[ I, 2 ] ) then
                   Begin
                     Video( 1 );
                     Write( #249 );
                     Video( 0 )
                   End;
              For I := 1 to Enemies do
               If ( Spot[ 1 ] = Ships[ I, 1 ] ) and
                  ( Spot[ 2 ] = Ships[ I, 2 ] ) then
                Begin
                  Cursor ( Spot[ 1 ], Spot[ 2 ] );
                  WriteShip( Ships[ I ] )
                End;
              For I := 1 to Enemies do
                Begin
                 If ((  Spot[ 1 ] = Ships[ I, 1 ] + 1  )  and
                     (  Spot[ 2 ] = Ships[ I, 2 ]      )) and
                    ((  OldSpot [ 1 ] = Ships [ I, 1 ] )  and
                     (  OldSpot [ 2 ] = Ships [ I, 2 ] )) then
                   Begin
                     Cursor ( OldSpot [ 1 ], OldSpot [ 2 ] );
                     WriteShip( Ships [ I ] )
                   End;
                 If ((  Spot[ 1 ] = Ships[ I, 1 ]      )  and
                     (  Spot[ 2 ] = Ships[ I, 2 ] + 1  )) and
                    ((  OldSpot [ 1 ] = Ships [ I, 1 ] )  and
                     (  OldSpot [ 2 ] = Ships [ I, 2 ] )) then
                   Begin
                     Cursor ( OldSpot [ 1 ], OldSpot [ 2 ] );
                     WriteShip( Ships [ I ] )
                   End;
                 If ((  Spot[ 1 ] = Ships[ I, 1 ] - 1  )  and
                     (  Spot[ 2 ] = Ships[ I, 2 ]      )) and
                    ((  OldSpot [ 1 ] = Ships [ I, 1 ] )  and
                     (  OldSpot [ 2 ] = Ships [ I, 2 ] )) then
                   Begin
                     Cursor ( OldSpot [ 1 ], OldSpot [ 2 ] );
                     WriteShip( Ships [ I ] )
                   End;
                 If ((  Spot[ 1 ] = Ships[ I, 1 ]      )  and
                     (  Spot[ 2 ] = Ships[ I, 2 ] - 1  )) and
                    ((  OldSpot [ 1 ] = Ships [ I, 1 ] )  and
                     (  OldSpot [ 2 ] = Ships [ I, 2 ] )) then
                   Begin
                     Cursor ( OldSpot [ 1 ], OldSpot [ 2 ] );
                     WriteShip( Ships [ I ] )
                   End;
                End;
              If  ( Spot[ 1 ] - YMove = Base[ 1 ] )
              and ( Spot[ 2 ] - XMove >= Base[ 2 ] - 1 )
              and ( Spot[ 2 ] - XMove <= Base[ 2 ] + 1 ) then
                Begin
                  Cursor( Base[ 1 ], Base[ 2 ] - 1 );
                  Write( '(=)' )
                End;
              HisShip;
              Docked := False
            End
         End;
      If AutoFire
      and Not( Docked ) then
         Begin
            Shot := Inrange;
            Service( InRange );
            XMove := 0;
            YMove := 0
         End;
      If Shot
      and Not( Over ) then
         TheirTurn;
      If ( Enemies <= 0 )
      and Not( APlanet )
      and Not( AScreener )
      and Not( Over ) then
         Begin
            GalCnt := GalCnt + 1;
            Merit := ShotCount;
            If GalCnt > 150 then
               Merit := Merit * 3000 * DrawNumber( 20 )
            else
               Merit := Merit * DrawNumber( 200 * GalCnt );
            Score := Score + 100 + Merit;
            Clear;
            Cursor( 10, 30 );
            Video( 1 );
            Write( 'Congratulations!' );
            Video( 0 );
            Cursor( 12, 20 );
            Write( 'Do you want to attack another quadrant? ' );
            Repeat
               read( kbd, Answer );
               Write( Answer, #8' '#8 );
               Answer := Upper( Answer )
            Until ( Answer = 'Y' )
            or    ( Answer = 'N' );
            If Answer = 'Y' then
               HyperSpace
            else
               Done := True
         End;
1: Until ( Shields <= 0 ) or ( Energy <= 0 ) or Over or Done;
End;


Procedure SaveShip;

Var     I,
        ShipNum,
        Size,
        Temp,
        Pstat   : Integer;

        Answer  : Char;

        ShipNam : String30;

        S       : Fleet;
        A       : Int3;

Begin
   If Not( Over ) then
      Repeat
         Cursor( 18, 15 );
         ClrEOL;
         Write( 'Do you wish to save your ship? ' );
         Read( Kbd, Answer );
         Answer := Upper( Answer )
      Until Answer in [ 'Y', 'N', 'R' ]
   else
      Answer := 'Y';
   If Answer = 'N' then
      Begin
         Cursor( 20, 15 );
         Write( 'Ship features not saved.' )
      End
   else
      Begin
         If Used then
            Begin
               assign(ShipFil,'SPACE.REC');
               Reset( ShipFil );
               read(ShipFil, S);
               If Answer = 'Y' then
                  ShipNam := S.Name[ IDNum ]
               else
                  Begin
                     Cursor( 20, 15 );
                     Write( 'New name : ' );
                     Readln(ShipNam);
                     Used := False
                  End;
               Temp := S.Sta[ IDNum ];
               If Temp <> -5 then
                  Begin
                     Temp := 0;
                     If ( MCnt > 0 ) then
                        Temp := MCnt
                  End;
               If Over then
                  Temp := -5;
               S.Name[ IDNum ] := ShipNam;
               S.Level[ IDNum ] := Score;
               S.Sta[ IDNum ] := Temp;
               S.Waste[ IDNum ] := S.Waste[ IDNum ] + Time - Start;
               S.Quests[IDNum] := S.Quests[IDNum] + 1;
               rewrite(ShipFil);
               write( ShipFil, S );
               Close( ShipFil )
            End
         else
            Begin
               repeat
                  Cursor( 20, 15 );
                  Write( 'Under which name? ' );
                  ClrEol;
                  Readln(ShipNam)
               until ShipNam <> '';
               assign( ShipFil, 'SPACE.REC' );
               reset(ShipFil);
               read(ShipFil, S);
               IDNum := S.Count + 1;
               S.Count := S.Count + 1;
               S.Name[ IDNum] := ShipNam;
               S.Level[ IDNum] := Score;
               If Over then
                  S.Sta[ IDNum ] := -5
               Else
                  S.Sta[ IDNum ] := 0;
               S.Waste[ IDNum ] := Time - Start;
               S.Quests[IDNum] := 1;
               rewrite( ShipFil );
               write( ShipFil, S );
               Close( ShipFil )
            End;
         If Not( Over ) then
            Begin
               Cursor( 18, 1 );
               ClearEOS;
               Cursor( 18, 15 );
               Write( 'Ship saved' );
               If Not( Used ) then
                  Write( ' as ', ShipNam, '.' )
               else
                  Write( '.' )
            End
      End
End;


Procedure Finish;

Var     I, J,
        PlayCnt,
        Size,
        Stats   : Integer;

        S,
        Store   : Fleet;

Begin
   Clear;
   If Over then
      Begin
         Video( 1 );
         For I := 1 to 10 do
            Begin
               Cursor( 10, 35 );
               ClrEOL;
               Write( 'You did it!' );
               Write( Bell )
            End;
         Cursor( 10, 35 );
         Video( 5 );
         Write( 'You did it!' );
         Video( 0 );
         Cursor( 15, 21 );
         Write( 'You destroyed the Alien mother planet!' );
         If Shields > 0 then
            Begin
               Cursor( 17, 30 );
               Write( 'Mission accomplished.' )
            End
         else
            Begin
               Cursor( 17, 19 );
               Write( 'Too bad you didn''t make it yourself either.' )
            End;
         Cursor( 19, 33 );
         Video( 9 );
         Write( 'End Adventure.' );
         Video( 0 );
         Pkiller := True;
         SaveShip
      End
   else
   If ( Shields > 0 )
   and ( Energy > 0 ) then
      Begin
         Cursor( 10, 32 );
         Video( 5 );
         Write( 'Congratulations!' );
         Video( 0 );
         Cursor( 12, 17 );
         Write( 'You have attained the ', ShotCount:1 );
         Case  ShotCount mod 10 of
                                         1 : If ShotCount <> 11 then
                                                Write( 'st' )
                                             else
                                                Write( 'th' );
                                         2 : Write( 'nd' );
                                         3 : Write( 'rd' );
                                else
                                             Write( 'th' );
            End;
         Write( ' level of expertise.' );
         Cursor( 14, 33 );
         Video( 9 );
         Write( 'End Adventure.' );
         Video( 0 );
         SaveShip
      End
   else
      Begin
         If Burnt then
            Begin
               Cursor( 10, 22 );
               Write( 'Starbases don''t like to be fired at.' );
               Stats := -1
            End
         else
         if Crisped then
            Begin
               Cursor( 10, 19 );
               Write( 'Stars tend to be pretty hot. Too hot maybe.' );
               Stats := -4
            End
         else
         if Energy <= 0 then
            Begin
               Cursor( 10, 17 );
               Write( 'You just ran out of energy and froze in space.' );
               Stats := -2
            End
         else
         if ( Shields <= 0 )
         and ( Shields > -2500 ) then
            Begin
               Cursor( 10, 21 );
               Write( 'Ah well, you didn''t make it this time.' );
               Stats := -3
            End
         else
            Begin
               Cursor( 10, 17 );
               Video( 5 );
               Write( '?Panic: Unusual low shield level - Score saved' );
               Video( 0 );
               Stats := MCnt
            End;
         Cursor( 12, 33 );
         Video( 9 );
         Write( 'End Adventure.' );
         Video( 0 );
         If Used then
            Begin
               assign( ShipFil, 'SPACE.REC' );
               reset(ShipFil);
               Read(ShipFil,S);
               S.Sta[ IdNum] := Stats;
               S.Level[ IDNum] := Score;
               S.Waste[ IDNum ] := S.Waste[ IDNum ] + Time - Start;
               S.Quests[IDNum] := S.Quests[IDNum] + 1;
               rewrite(ShipFil);
               write( ShipFil, S );
               Close( ShipFil )
            End
      End;
   Cursor( 21, 1 )
End;


Procedure GetShip;

label 1;

Var     I, J, K,
        ShipNum,
        Size,
        Stats   : Integer;

        Ans,
        Answer  : Char;

        NiceNam,
        OldName,
        ShipNam : String30;

        S: Fleet;
        A: Int3;

Begin
   Used := False;
   IDNum := 0;
   assign( ShipFil, 'SPACE.REC' );
   reset(ShipFil);
   read( ShipFil, S);
   ShipNum := S.Count;
   Close( ShipFil );
   If (ShipNum < ShipMax) and (Shipnum > 0) then
   begin
      Cursor( 18, 17 );
      Video( 1 );
      Write( 'Do you wish to make use of your fleet? ' );
      Video( 0 );
      Read( kbd, Answer );
      Answer := Upper( Answer )
   end
   else if Shipnum > 0 then
      Answer := 'Y'
   else
      Answer := 'N';
   If Answer <> 'N' then
   begin
      Clear;
      Cursor( 5, 1 );
      Video( 1 );
      Write( 'Vessels presently forming your fleet:' );
      Video( 0 );
      For I := 1 to ShipNum do
      begin
         Cursor( 7 + (( I - 1 ) mod 12 ), 1 );
         Write( I:2, '. ', S.Name[ I ] );
         ClrEOL;
         Cursor( 7 + (( I - 1 ) mod 12 ), 30 );
         Write( '   - ', S.Level[ I ]:15:0 );
         Video( 1 );
         If S.Sta[ I ] < 0 then
            case S.Sta[ I ] of -1 : Write( ' ~B~' );
                               -2 : Write( ' ~F~' );
                               -3 : Write( ' ~D~' );
                               -4 : Write( ' ~S~' );
                               -5 : Write( ' *P*' );
            end
         else
            Write( '    ' );
         Video( 0 );
         Write( '  ' );
         WriteTime( S.Waste[ I ] );
         Write( ' hrs, ', S.Quests[ I ]:4, ' quest' );
         If S.Quests[ I ] = 1 then
            Write( '.' )
         else
            Write( 's.')
      end;
      repeat
         If ShipNum > 1 then
         begin
            Cursor( 22, 1 );
            ClrEOL;
            Write( 'Which ship do you wish to use? (type its number) ' );
            Readln(ShipNam)
         end
         else
            ShipNam := '1';
         Val(ShipNam,IDNum,I)
      until (I = 0) and (IDNum in [1..ShipNum]);
      NiceNam := S.Name[IDNum];
      Stats := S.Sta[IDNum];
      Score := S.Level[IDNum];
      MCnt := 0;
      Used := true;
      Cursor( 20, 1 );
      ClearEOS;
      Cursor( 20, 1 );
      If Stats <> 0 then
      begin
         Case Stats of
         -1 : Write( 'The ', NiceNam, ' has been utterly destroyed by a Starbase.' );
         -2 : Write( 'The ', NiceNam, ' is somewhere in space, solidly frozen.' );
         -3 : Write( 'The ', NiceNam, ' has perished in combat action.' );
         -4 : Write( 'The ', NiceNam, ' has been burnt to crisp by a star.' );
         -5 : Write( 'The ', NiceNam, ' has succeeded in destroying the Alien Planet.' );
         else
            begin
               Write( 'The ', NiceNam, ' so far wiped out ', Stats:1, ' Alien mothership' );
               If Stats = 1 then
                  Write( '!' )
               else
                  Write( 's!' );
               MCnt := Stats
            end;
         end;
         PKiller := ( Stats = -5 );
         If ( Stats < 0 ) and ( ShipNum < ShipMax ) then
         begin
            Repeat
               Cursor( 22, 1 );
               ClrEOL;
               Write( 'Do you wish to ' );
               If Stats > -5 then
                  Write( 'rebuild it? ' )
               else
                  Write( 'set out with it once more? ');
               Read( Kbd, Answer );
               Answer := Upper( Answer )
            Until ( Answer = 'Y' ) or ( Answer = 'N' );
            if Stats > -5 then Score := 0;
            Cursor( 22, 1 );
            ClrEOL;
            If Answer = 'Y' then
               Write( 'The ', NiceNam, ' sets out once more to conquer the Universe!'#7 )
            else
            begin
               Used := False;
               Write( 'Yet unknown, may you soon have a fearful reputation!'#7 )
            end
         end
      end
      else
      begin
         Cursor( 22, 1 );
         Write( 'The ', NiceNam, ' rules the ether!'#7 )
      end;
      Sleep(3)
   end
End;




Procedure Introduction;

Type    Char1000        = Array[1..1000] of Char;

Var     I, J, K, L,
        Job1,
        Job2,
        Size,
        VetCnt,
        QuestCnt,
        MaxQ,
        MaxId,
        PShips          : Integer;

        Order: array [1..ShipMax] of integer;

        TotalScore,
        Wasted,
        Expertise,
        MaxExp          : Real;

        C               : Char;

        Message         : Array[1..80] of Char;

        DFile,
        HFile           : Text;

        MFile           : File of Char1000;
        M               : Char1000;
        S               : Fleet;

Begin
   Energy := 1500 + DrawNumber( 30 );
   Score := 0;
   MCnt := 0;
   DelTime := 20;
   BeepTime := 150;
   BeepFreq := 440;
   Clear;
   Cursor( 2, 30 );
   Video(1);
   Write( 'Star Quest' );
   Video( 0 );
   Cursor( 4, 10 );
   Write( 'Written by Pieter W. G. Bots, The Netherlands, April 1981' );
   assign(DFile, 'SPACE.SND');
   {$I-}
   reset(DFile);
   if IOResult = 0 then
   begin
      read(DFile,BeepTime);
      if IOResult = 0 then
      begin
         read(DFile, BeepFreq);
         if IOResult = 0 then
            read(DFile, DelTime)
      end
   end;
   if IOResult <> 0 then write(#7);
   {$I+}
   close(DFile);
   Cursor( 6, 24 );
   ClrEOL;
   Video( 1 );
   Write( 'Do you want instructions? ' );
   Video( 0 );
   Read( Kbd, C );
   If Upper( C ) = 'Y' then
      Begin
         assign( HFile, 'SPACE.HLP');
         {$I-}
         reset(HFile);
         {$I+}
         If IOresult <> 0 then
            Begin
               Cursor( 6, 22 );
               Video( 1 );
               Write( '?No instructions available - Sorry' );
               Video( 0 );
               Sleep( 3 )
            End
         else
            Begin
               Readln( HFile, Message );
               I := 1;
               Repeat
                  Clear;
                  Repeat
                     C := Message[ I ];
                     I := I + 1;
                     If C <> '&' then
                     begin
                        if C = '' then
                           Video(1)
                        else if C = '' then
                           Video(0)
                        else
                           Write( C )
                     end
                     else
                        Begin
                           Writeln;
                           C := Message[ I ];
                           I := 1;
                           Readln( HFile, Message )
                        End
                  Until ( C = '&' ) or ( C = '$' );
                  If C = '&' then
                     Begin
                        Cursor( 24, 11 );
                        Video( 1 );
                        Write( 'Type ''Q'' to exit, any other key to continue... ' );
                        Video( 0 );
                        Read( Kbd, C )
                     End
                  else
                  begin
                     Read(Kbd, C);
                     C := '$'
                  end
               Until ( Upper( C ) = 'Q' ) or ( C = '$' );
               Clear;
               Close( HFile )
            End
      End
   else
      Clear;
      assign( MFile, 'SPACE.MSG' );
      {$I-}
      reset(MFile);
      {$I+}
      If IOResult = 0 then
         Begin
            Video( 9 );
            Cursor( 4,24 );
            Write( 'Message from Starfleet Command:' );
            Video( 0 );
            I := 1;
            Cursor( 7, 1 );
            Seek( MFile, 1 );
            read(MFile, M);
            While ( Ord( M[ I ] ) <> 0 ) and ( I < 1000 ) do
               Begin
                  If Ord( M[ I ] ) = 13 then
                     Writeln
                  else
                     Write( M[ I ] );
                  I := I + 1
               End;
            Close( MFile );
            Cursor( 23, 77 );
            Sleep( I div 45 + 2 )
         End;
   Clear;
   Cursor( 3, 10 );
   assign( ShipFil, 'SPACE.REC' );
   {$I-}
   reset(ShipFil);
   {$I+}
   If IOResult <> 0 then
   begin
      S.Count := 0;
      Rewrite( ShipFil );
      write(ShipFil, S)
   end;
   Close( ShipFil );
   GetShip
End;



{** Main Body of Program **}

Begin
   VersionNum := 'Ver 4.0-04';
   AlarmBell := false;
   Alien := false;
   APlanet := false;
   AScreener := false;
   AutoFire := false;
   Burnt := false;
   Buzz := true;
   Crisped := false;
   Docked := false;
   Explo := false;
   HisFire := false;
   HitBase := false;
   Invisible := false;
   Over := false;
   PKiller := false;
   Used := false;
   Saucer := '(O)';
   Horror := '=X=';
   GiantS := '~*~';
   PlasmS := '>=<';
   DStar := ']*[';
   BShip := '}+{';
   Cruiser := '^+^';
   SBase := '(=)';
   Dir[ 1, 1 ] := 1;
   Dir[ 1, 2 ] := -1;
   Dir[ 2, 1 ] := 1;
   Dir[ 2, 2 ] := 0;
   Dir[ 3, 1 ] := 1;
   Dir[ 3, 2 ] := 1;
   Dir[ 4, 1 ] := 0;
   Dir[ 4, 2 ] := -1;
   Dir[ 5, 1 ] := 0;
   Dir[ 5, 2 ] := 0;
   Dir[ 6, 1 ] := 0;
   Dir[ 6, 2 ] := 1;
   Dir[ 7, 1 ] := -1;
   Dir[ 7, 2 ] := -1;
   Dir[ 8, 1 ] := -1;
   Dir[ 8, 2 ] := 0;
   Dir[ 9, 1 ] := -1;
   Dir[ 9, 2 ] := 1;
   Inv[ 1 ] := 9;
   Inv[ 2 ] := 8;
   Inv[ 3 ] := 7;
   Inv[ 4 ] := 6;
   Inv[ 6 ] := 4;
   Inv[ 7 ] := 3;
   Inv[ 8 ] := 2;
   Inv[ 9 ] := 1;
   Base[1] := 0;
   Base[2] := 0;
   Base[3] := 0;
   Introduction;
   Start := Time;
   Ship := #4;
   GalCnt := 0;
   AScreener := false;
   Alien := false;
   APlanet := false;
   Enemies := DrawNumber( 19 ) + 1;
   Rate := 1;
   Hurt := ShotCount;
   Dock( 0 );
   Docked := False;
   Over := False;
   Clear;
   PlaceStars( Stars );
   PlaceShips;
   StarBase;
   PutHimDown;
   Battle;
   Finish
End.
